% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeRun.R
\name{summarizeRunOne}
\alias{summarizeRunOne}
\title{Derive point estimates for c, pi, phi, and Z for a particular sample}
\usage{
summarizeRunOne(object, file, se.matrix, burn.in = 0, post.thin = 1)
}
\arguments{
\item{object}{a \code{\link[PhIPData]{PhIPData}} object}

\item{file}{path to rds file}

\item{se.matrix}{logical matrix indicating which peptides were identified as
super-enriched peptides}

\item{burn.in}{number of iterations to be burned}

\item{post.thin}{thinning parameter}
}
\value{
list of point estimates for c, pi, phi and Z
}
\description{
Posterior means are used as point estimates for \eqn{c}, \eqn{\pi},
\eqn{\phi}, and \eqn{Z}. As super-enriched peptides are tossed out before
MCMC sampling, super-enriched peptides return \code{NA} for the \eqn{\phi}
and \eqn{Z} point estimates. Indices corresponding to a particular peptide in
the MCMC sampler are mapped back to the original peptide names.
}
