% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot-functions.R,
%   R/plotDMR-functions.R, R/plot_thresholds.R
\name{plot}
\alias{plot}
\alias{plot,betaHMMResults-method}
\alias{plot-methods}
\alias{plot,dmcResults-method}
\alias{plot,threshold_Results-method}
\title{Visualize results from \code{betaHMM}/ \code{dmc_identification}/
\code{threshold_identification} functions.}
\usage{
plot(x, ...)

\S4method{plot}{betaHMMResults}(
  x,
  chromosome = NULL,
  what = c("fitted density", "kernel density", "uncertainty"),
  treatment_group = NULL,
  AUC = NULL,
  uncertainty_threshold = 0.2,
  title = NULL,
  ...
)

\S4method{plot}{dmcResults}(
  x,
  start_CpG = NULL,
  end_CpG = NULL,
  treatment_group = NULL,
  N = NULL,
  title = NULL,
  ...
)

\S4method{plot}{threshold_Results}(x, plot_threshold = TRUE, title = NULL, ...)
}
\arguments{
\item{x}{An object of class
\code{\link[betaHMM:betaHMMResults]{betaHMMResults}}/
\code{\link[betaHMM:dmcResults]{dmcResults}}/
\code{\link[betaHMM:dmcResults]{threshold_Results}} object.}

\item{...}{Other graphics parameters.}

\item{chromosome}{The chromosome number for which the plot is to be
displayed.}

\item{what}{The different plots that can be obtained are either
'fitted density','kernel density' or
'uncertainty' (default = 'fitted density').}

\item{treatment_group}{The names of the different treatment groups
to be displayed in the plot.If no value is passed then the sample names
estimated by the \code{betaHMM} function are used.}

\item{AUC}{The AUC values for that chromosome.}

\item{uncertainty_threshold}{The uncertainty threshold value used for DMC
identification.}

\item{title}{The title that the user wants to display.
If no title is to be displayed the default is 'NULL'.}

\item{start_CpG}{The IlmnID of starting CpG site when plotting the DMCs.}

\item{end_CpG}{The IlmnID of ending CpG site/ the total number
of CpGs to be plotted excluing the starting CpG site when plotting the DMCs.}

\item{N}{The number of DNA samples corresponding to each
treatment group analysed using the betaHMM model. If `NULL`, the value from
\code{betaHMMResults} object is selected.}

\item{plot_threshold}{The "TRUE" option displays the threshold points in the
graph for the 3 state betaHMM model (default = "FALSE").}
}
\value{
This function displays the following plots as requested by the user
when analysing the \code{\link[betaHMM:betaHMMResults]{betaHMMResults}}
output:
\itemize{
\item fitted density estimates - Plot showing the fitted density estimates
of the clustering solution under the optimal model selected.
\item kernel density estimates - Plot showing the kernel density estimates
of the clustering solution under the optimal model selected.
\item uncertainty -  A boxplot showing the uncertainties in the
hidden state estimation.
}

The function displays the  DMCs and DMRs plot from
the \code{\link[betaHMM:dmcResults]{dmcResults}} object.

The function displays the plot for the estimated shape parameters
and threshold for the methylation states in a single DNA treatment condition
from the \code{\link[betaHMM:threshold_Results]{threshold_Results}} object.
}
\description{
Visualize results from \code{betaHMM}/ \code{dmc_identification}/
\code{threshold_identification} functions.
}
\examples{
## Use simulated data for the betaHMM workflow example
set.seed(12345)

## read files
data(sample_methylation_file)
data(sample_annotation_file)
# Run betaHMM function
beta_out <- betaHMM(sample_methylation_file[1:50,],
                    sample_annotation_file[1:50,],
                    M = 3, N = 4, R = 2,iterations=2,
                    parallel_process = FALSE, seed = 12345,
                    treatment_group = c("Benign","Tumour"))

## Run dmc_identification function
dmc_out <- dmc_identification(beta_out)

# Run dmr_identification function
dmr_out <- dmr_identification(dmc_out, parallel_process = FALSE)

# Plot functions
# Get the AUC values calculated for each hidden state
AUC_chr <- AUC(dmc_out)

## plot the uncertainty for each hidden state
plot(beta_out, chromosome = "1", what = "uncertainty")

## Use simulated data for the betaHMM workflow example
set.seed(12345)

## read files
data(sample_methylation_file)
data(sample_annotation_file)
# Run betaHMM function
beta_out <- betaHMM(sample_methylation_file[1:50,],
                    sample_annotation_file[1:50,],
                    M = 3, N = 4, R = 2,iterations=2,
                    parallel_process = FALSE, seed = 12345,
                    treatment_group = c("Benign","Tumour"))

## Run dmc_identification function
dmc_out <- dmc_identification(beta_out)

# Run dmr_identification function
dmr_out <- dmr_identification(dmc_out, parallel_process = FALSE)

# Plot functions
# Get the AUC values calculated for each hidden state
AUC_chr <- AUC(dmc_out)

## plot the uncertainty for each hidden state
plot(beta_out, chromosome = "1", what = "uncertainty")

}
\author{
Koyel Majumdar
}
