% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummarizedExperiment_tidiers.R
\name{SummarizedExperiment_tidiers}
\alias{SummarizedExperiment_tidiers}
\alias{tidy.RangedSummarizedExperiment}
\title{Tidying methods for Biobase's SummarizedExperiment objects}
\usage{
\method{tidy}{RangedSummarizedExperiment}(x, addPheno = FALSE,
  assay = SummarizedExperiment::assayNames(x)[1L], ...)
}
\arguments{
\item{x}{SummarizedExperiment object}

\item{addPheno}{whether columns should be included in the tidied output
for those in the SummarizedExperiment colData}

\item{assay}{Which assay to return as the \code{value} column. Defaults to
\code{assays(x)[[1L]]}}

\item{...}{extra arguments (not used)}
}
\value{
\code{tidy} returns a data frame with one row per gene-sample
combination, with columns
  \item{gene}{gene name}
  \item{sample}{sample name (from column names)}
  \item{value}{expressions}

If \code{addPheno} is TRUE then information from colData
is added.
}
\description{
Tidying methods for Biobase's SummarizedExperiment objects
}
\details{
\code{addPheno=TRUE} adds columns that are redundant (since they
add per-sample information to a per-sample-per-gene data frame), but that
are useful for some kinds of graphs and analyses.
}
\examples{
if (require("SummarizedExperiment", "airway")) {
    data(airway)

    se <- airway
    tidy(se)
}

}
