test_that("indent_text correctly indents text", {
  # Test input and expected output
  test_input <- "Hello\nWorld"
  expected_output <- "  Hello\n  World"

  # Check if the function output matches the expected output
  expect_equal(indent_text(test_input), expected_output)
})

test_that("prepare_tests correctly trims whitespace", {
  # Test input and expected output
  test_input <- "  Hello World  "
  expected_output <- "Hello World"

  # Check if the function output matches the expected output
  expect_equal(prepare_tests(test_input), expected_output)
})

test_that("auto_quote correctly adds quotes", {
  # Test input and expected output
  test_strings <- c("hello", "'hello'", "\"hello\"", "hello world", "1_hello")
  expected_output <-
    c("hello", "'hello'", "\"hello\"", "\"hello world\"", "\"1_hello\"")

  # Check if the result matches the expected output
  expect_equal(auto_quote(test_strings), expected_output)
})

test_that("internal_longtests_roclet_clean returns a message for files not created by biocroxytest", {
  # Setup:
  base_path <- tempdir()
  longtests_path <- file.path(base_path, "longtests", "testthat")
  unlink(longtests_path, recursive = TRUE, force = TRUE)
  dir.create(longtests_path, recursive = TRUE, showWarnings = FALSE)
  c("# No Generated by biocroxytest: do not edit by hand!") |>
    writeLines(file.path(longtests_path, "test-biocroxytest-1.R"))

  results <- list("-1.R" = NA)

  internal_longtests_roclet_output(results, longtests_path) |>
    expect_equal("-1.R") |>
    expect_snapshot()
})
