% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.bioTMLE}
\alias{plot.bioTMLE}
\title{Plot p-values from moderated statistical tests for class biotmle}
\usage{
\method{plot}{bioTMLE}(x, ..., type = "pvals_adj")
}
\arguments{
\item{x}{object of class \code{biotmle} as produced by an appropriate call
to \code{biomarkertmle}}

\item{...}{additional arguments passed \code{plot} as necessary}

\item{type}{character describing whether to provide a plot of unadjusted or
adjusted p-values (adjustment performed via Benjamini-Hochberg)}
}
\value{
object of class \code{ggplot} containing a histogram of the raw or
 Benjamini-Hochberg corrected p-values (depending on user input).
}
\description{
Histogram of raw or FDR-adjusted p-values from the moderated t-test.
}
\examples{
\dontrun{
library(dplyr)
library(biotmleData)
library(SuperLearner)
library(SummarizedExperiment)
data(illuminaData)

colData(illuminaData) <- colData(illuminaData) \%>\%
  data.frame() \%>\%
  mutate(age = as.numeric(age > median(age))) \%>\%
  DataFrame()
benz_idx <- which(names(colData(illuminaData)) \%in\% "benzene")

biomarkerTMLEout <- biomarkertmle(
  se = illuminaData,
  varInt = benz_idx,
  bppar_type = BiocParallel::SerialParam(),
  g_lib = c("SL.mean", "SL.glm"),
  Q_lib = c("SL.mean", "SL.glm")
)

limmaTMLEout <- modtest_ic(biotmle = biomarkerTMLEout)

plot(x = limmaTMLEout, type = "pvals_adj")
}
}
