% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flogit.R
\name{flogit}
\alias{flogit}
\title{Helper function: squeezed logit}
\usage{
flogit(p, sqz = 1e-06)
}
\arguments{
\item{p}{a vector of values between 0 and 1 inclusive}

\item{sqz}{the amount by which to 'squeeze', default is .000001}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{   a vector of values between -Inf and +Inf
}\if{html}{\out{</div>}}
}
\description{
Helper function: squeezed logit
}
\examples{

  set.seed(1234)
  p <- runif(n=1000)
  summary(p) 

  sqz <- 1 / (10**6)
  x <- flogit(p, sqz=sqz)
  summary(x) 

  all( abs(p - fexpit(x, sqz=sqz)) < sqz )
  all( abs(p - fexpit(flogit(p, sqz=sqz), sqz=sqz)) < sqz ) 

}
