% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnem_main.r
\name{scoreDnf}
\alias{scoreDnf}
\title{score a boolean network}
\usage{
scoreDnf(
  bString,
  CNOlist,
  fc,
  expression = NULL,
  model,
  method = "cosine",
  sizeFac = 10^-10,
  NAFac = 1,
  parameters = list(cutOffs = c(0, 1, 0), scoring = c(0.25, 0.5, 2)),
  NEMlist = NULL,
  relFit = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{bString}{binary string denoting the boolean network}

\item{CNOlist}{CNOlist object (see package CellNOptR), if available.}

\item{fc}{m x l matrix of foldchanges of gene expression values or 
equivalent input
(normalized pvalues, logodds, ...) for m E-genes and l contrasts. If left 
NULL, the gene expression
data is used to calculate naive foldchanges.}

\item{expression}{Optional normalized m x l matrix of gene expression data 
for m E-genes and l experiments.}

\item{model}{Model object including the search space, if available.
See CellNOptR::preprocessing.}

\item{method}{Scoring method can be "cosine", a correlation,
or a distance measure. See ?cor and ?dist for details.}

\item{sizeFac}{Size factor penelizing the hyper-graph size.}

\item{NAFac}{factor penelizing NAs in the data.}

\item{parameters}{parameters for discrete case (not recommended);
has to be a list with entries cutOffs and scoring:
cutOffs = c(a,b,c) with a (cutoff for real zeros),
b (cutoff for real effects),
c = -1 for normal scoring, c between 0 and
1 for keeping only relevant % of E-genes,
between -1 and 0 for keeping only a specific quantile of E-genes,
and c > 1 for keeping the top c E-genes;
scoring = c(a,b,c) with a (weight for real effects),
c (weight for real zeros),
b (multiplicator for effects/zeros between a and c);}

\item{NEMlist}{NEMlist object (optional)}

\item{relFit}{if TRUE a relative fit for each
E-gene is computed (not recommended)}

\item{verbose}{TRUE for verbose output}
}
\value{
numeric value (score)
}
\description{
computes the score of a boolean network given the model and data
}
\examples{
sim <- simBoolGtn()
scoreDnf(sim$bString, sim$CNOlist, sim$fc, model=sim$model)
}
\author{
Martin Pirkl
}
