% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{ID2Enzyme}
\alias{ID2Enzyme}
\title{A helper function for converting names/synonyms to EC numbers.}
\usage{
ID2Enzyme(brenda, ids)
}
\arguments{
\item{brenda}{A \code{tibble} generated from \code{\link[=ReadBrenda]{ReadBrenda()}}.}

\item{ids}{A character vector of IDs to be converted.}
}
\value{
A tibble with columns ID, EC, and at least one of (RECOMMENDED_NAME,
SYSTEMATIC_NAME and SYNONYMS).
}
\description{
A helper function for converting names/synonyms to EC numbers.
}
\details{
The function goes through "RECOMMENDED_NAME", "SYSTEMATIC_NAME", and
"SYNONYMS" in the BRENDA file, and uses regexes to look for the given IDs.
Values in the three columns are kept if the regex had a hit, otherwise NA is
filled. The function can take in IDs of multiple sources, e.g. \code{c("ADH4", "CD38", "pyruvate dehydrogenase")}. Note that using aliases instead of
symbols could lead to false positives in the output table.
}
\examples{
df <- ReadBrenda(system.file("extdata", "brenda_download_test.txt",
                          package = "brendaDb"))
ID2Enzyme(df, c("CD38", "ADH4", "pyruvate dehydrogenase"))

}
