% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSignatures.R
\name{getMetaSignatures}
\alias{getMetaSignatures}
\title{Obtain meta-signatures for a column of interest}
\usage{
getMetaSignatures(
  df,
  column,
  direction = c("BOTH", "UP", "DOWN"),
  min.studies = 2,
  min.taxa = 5,
  comb.fun = sum,
  ...
)
}
\arguments{
\item{df}{\code{data.frame} storing BugSigDB data. Typically obtained via
\code{\link{importBugSigDB}}.}

\item{column}{character. Column of interest. Need to be a valid column name
of \code{df}.}

\item{direction}{character. Indicates direction of abundance change for signatures
to be included in the computation of meta-signatures. Use \code{"UP"} to restrict
computation to signatures with increased abundance in the exposed group. Use 
\code{"DOWN"} to restrict to signatures with decreased abundance in the exposed
group. Defaults to \code{"BOTH"} which will not filter signatures by direction
of abundance change.}

\item{min.studies}{integer. Minimum number of studies for a category in \code{column}
to be included. Defaults to 2, which will then only compute meta-signatures for
categories investigated by at least two studies.}

\item{min.taxa}{integer. Minimum size for meta-signatures. Defaults to 5, which
will then only include meta-signatures containing at least 5 taxa.}

\item{comb.fun}{function. Function for combining sample size of the exposed group
and sample size of the unexposed group into an overall study sample size. Defaults
to \code{sum} which will simply add sample sizes of exposed and unexposed group.}

\item{...}{additionals argument passed on to \code{\link{getSignatures}}.}
}
\value{
A \code{list} of meta-signatures, each meta-signature being a named
numeric vector. Names are the taxa of the meta-signature, numeric values 
correspond to sample size weights associated with each taxon.
}
\description{
Functionality for obtaining meta-signatures for a column of 
interest
}
\examples{
 df <- importBugSigDB()

 # Body-site specific meta-signatures composed from signatures reported as both 
 # increased or decreased across all conditions of study:
 bs.meta.sigs <- getMetaSignatures(df, column = "Body site")

 # Condition-specific meta-signatures from fecal samples, increased
 # in conditions of study. Use taxonomic names instead of the default NCBI IDs:
 df.feces <- df[df$`Body site` == "Feces", ]
 cond.meta.sigs <- getMetaSignatures(df.feces, column = "Condition", 
                                     direction = "UP", tax.id.type = "taxname")

 # Inspect the results
 names(cond.meta.sigs)
 cond.meta.sigs["Bipolar disorder"]
}
\seealso{
getSignatures
}
