% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessment.R
\name{colMatch}
\alias{colMatch}
\title{Column match between two matrices by minimum mean absolute difference}
\usage{
colMatch(A, B, force = FALSE)
}
\arguments{
\item{A}{The first matrix which will be matched}

\item{B}{The second matrix, the return index will be used on}

\item{force}{bool(1), If TRUE, force traversing all permutations of B to
find the optimised match to A with computing cost of O(n!). Otherwise, use
greedy search with computing cost of O(n^2).}
}
\value{
\code{idx}, the column index of B to be matched to A
}
\description{
Column match between two matrices by minimum mean absolute difference
}
\examples{
matA <- matrix(sample(seq(12)), nrow = 3)
col_idx <- sample(4)
matB <- matA[, col_idx]
colMatch(matB, matA)
}
