% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{plot_tree}
\alias{plot_tree}
\title{Plot cluster tree}
\usage{
plot_tree(tree, direction = "rightwards", cex = 0.7, ...)
}
\arguments{
\item{tree}{List containing tree structure. Output from 
\code{\link{build_tree}}}

\item{direction}{\code{c('rightwards','downwards')}; 
the direction of dendrogram}

\item{cex}{Font size of edge/tip labels}

\item{...}{Other parameters to \code{\link{plot.phylo}}}
}
\value{
\code{NULL}
}
\description{
Visualize the output of \code{\link{build_tree}} as a dendrogram.
}
\details{
Uses \code{\link[ape]{plot.phylo}} to visualize cluster tree.
}
\examples{
set.seed(1)
x <- simulate_whx(nrow=50,ncol=100,rank=5)
s <- scNMFSet(x$x)
s <- vb_factorize(s,ranks=seq(2,8),nrun=5)
tree <- build_tree(s,rmax=5)
plot_tree(tree)
}
