% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{MigrationStats}
\alias{MigrationStats}
\title{Compute Cell Migration Statistics}
\usage{
MigrationStats(tracks, interval_time, pixel_micron)
}
\arguments{
\item{tracks}{data.frame with cell tracks information}

\item{interval_time}{integer, time interval between two successive
frames were taken}

\item{pixel_micron}{integer, image resolution, i.e. number of
pixels
per micron}
}
\value{
list of stats calculated for the cell tracks.
Info include variables of speed,
distance, euclidean displacement, persistence, angular
displacement,
yFMI, xFMI, y-displacement, x-displacement and frames
}
\description{
Calculate the statistics from X/Y positional data obtained from
cell tracks
}
\examples{
x0 <- cbind(c(30, 35, 1, 5, 6, 7, 50, 55, 56, 58),
            c(29, 37, 2, 7, 4, 9, 40, 50, 59, 49),
            c( 1,  2, 1, 2, 3, 4,  1,  2,  3,  4),
            c( 1,  1, 2, 2, 2, 2,  3,  3,  3,  3))
cellmigRation:::MigrationStats(x0, 10, 10)


}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
\url{https://www.mathworks.com/matlabcentral/fileexchange/60349-fasttracks}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
