% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{rmPreProcessing}
\alias{rmPreProcessing}
\title{Data preprocessing for random migration (RM)}
\usage{
rmPreProcessing(
  object,
  PixelSize = 1.24,
  TimeInterval = 10,
  FrameN = NULL,
  ExpName = NULL
)
}
\arguments{
\item{object}{\code{CellMig} class object.}

\item{PixelSize}{A numeric value of the physical size of a pixel.
Default is 1.24.}

\item{TimeInterval}{A numeric value of the time elapsed
between successive frames in the time-lapse stack. Default is
10 min.}

\item{FrameN}{A numeric value of the number of frames.
Default is NULL}

\item{ExpName}{string, name of the experiment. Can be NULL}
}
\value{
An CellMig class object with preprocessed data.
}
\description{
This function allows preprocessing of the trajectory
data from random
migration (RM) experiments.
}
\examples{
TrajectoryDataset <- get(data(TrajectoryDataset))
rmDF=TrajectoryDataset[seq(1,40,by=1),]
rmTD <- CellMig(rmDF)
rmTD <- rmPreProcessing(rmTD, FrameN=30)

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
