% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MergePEReads.R
\name{MergePEReads}
\alias{MergePEReads}
\title{Generate fragment-level information for paired-end sequencing reads}
\usage{
MergePEReads(bed_file, output.dir = "", id = "")
}
\arguments{
\item{bed_file}{a (sorted) BED file of paired-end reads.}

\item{output.dir}{a path to the output directory. Default is "", 
which means the output will not be written into a file.}

\item{id}{an ID name for the input data. Default is "", 
which means the output will not be written into a file.}
}
\value{
a list in BED file format and/or written to 
an output BED file.
}
\description{
Merge BED file (the output of `bedtools bamtobed`) to 
fragment-level for paired-end sequencing reads.
}
\examples{
## input files
demo.dir <- system.file("data", package="cfTools")
PEReads <- file.path(demo.dir, "demo.sorted.bed.txt.gz")

output <- MergePEReads(PEReads)

}
