% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple.R
\name{saveDelayedObject,array-method}
\alias{saveDelayedObject,array-method}
\alias{saveDelayedObject,CsparseMatrix-method}
\title{Saving simple seed classes}
\usage{
\S4method{saveDelayedObject}{array}(x, file, name)

\S4method{saveDelayedObject}{CsparseMatrix}(x, file, name)
}
\arguments{
\item{x}{An R object of the indicated class.}

\item{file}{String containing the path to a HDF5 file.}

\item{name}{String containing the name of the group to save into.}
}
\value{
A \code{NULL}, invisibly.
A group is created at \code{name} containing the contents of \code{x}.
}
\description{
Methods to save simple seed classes - namely, ordinary matrices or sparse \pkg{Matrix} objects - into the delayed operation file.
See \dQuote{Dense arrays} and \dQuote{Sparse matrices} at \url{https://artifactdb.github.io/chihaya/} for more details.
}
\details{
For string arrays, missing values are handled by the \code{"missing-value-placeholder"} attribute on the \code{data} dataset.
All \code{NA} values in the array are replaced by the placeholder value in the attribute when they are saved inside the HDF5 file.
If this attribute is not present, it can be assumed that all strings are non-missing.
}
\examples{
# Saving an ordinary matrix.
X <- matrix(rpois(100, 2), 5, 20)
Y <- DelayedArray(X)
temp <- tempfile(fileext=".h5")
saveDelayed(Y, temp)
rhdf5::h5ls(temp)
loadDelayed(temp)

# Saving a sparse matrix.
X <- rsparsematrix(100, 20, 0.1)
Y <- DelayedArray(X)
temp <- tempfile(fileext=".h5")
saveDelayed(Y, temp)
rhdf5::h5ls(temp)
loadDelayed(temp)

}
\author{
Aaron Lun
}
