% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_variability.R
\name{computeVariability}
\alias{computeVariability}
\title{computeVariability}
\usage{
computeVariability(
  object,
  bootstrap_error = TRUE,
  bootstrap_samples = 1000,
  bootstrap_quantiles = c(0.025, 0.975),
  na.rm = TRUE
)
}
\arguments{
\item{object}{output from \code{\link{computeDeviations}}}

\item{bootstrap_error}{compute bootstrap confidence interval}

\item{bootstrap_samples}{number of bootstrap samples to take}

\item{bootstrap_quantiles}{quantiles for bootstrap}

\item{na.rm}{remove NAs? default is true}
}
\value{
data.frame with columns for name, variability, bootstrap lower bound,
bootstrap upper bound, raw p value, adjust p value.
}
\description{
function to compute overall variability of motif sets across samples
}
\examples{
# Load very small example results from computeDeviations
data(mini_dev, package = "chromVAR")
variability <- computeVariability(mini_dev)                        
}
