% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_kmers.R
\name{matchKmers}
\alias{matchKmers}
\alias{matchKmers,character,DNAStringSet-method}
\alias{matchKmers,character,character-method}
\alias{matchKmers,character,DNAString-method}
\alias{matchKmers,character,GenomicRanges-method}
\alias{matchKmers,character,RangedSummarizedExperiment-method}
\alias{matchKmers,numeric,ANY-method}
\alias{matchKmers,DNAStringSet,ANY-method}
\alias{matchKmers,DNAString,ANY-method}
\title{matchKmers}
\usage{
matchKmers(k, subject, ...)

\S4method{matchKmers}{character,DNAStringSet}(k, subject, out = c("matches", "positions"), ranges = NULL)

\S4method{matchKmers}{character,character}(k, subject, out = c("matches", "positions"), ranges = NULL)

\S4method{matchKmers}{character,DNAString}(k, subject, out = c("matches", "positions"), ranges = NULL)

\S4method{matchKmers}{character,GenomicRanges}(
  k,
  subject,
  genome = Seqinfo::genome(subject),
  out = c("matches", "positions")
)

\S4method{matchKmers}{character,RangedSummarizedExperiment}(k, subject, ...)

\S4method{matchKmers}{numeric,ANY}(k, subject, ...)

\S4method{matchKmers}{DNAStringSet,ANY}(k, subject, ...)

\S4method{matchKmers}{DNAString,ANY}(k, subject, ...)
}
\arguments{
\item{k}{k}

\item{subject}{either \code{\link[GenomicRanges]{GenomicRanges}},
\code{\link[Biostrings]{DNAStringSet}}, \code{\link[Biostrings]{DNAString}},
or character vector}

\item{...}{additional arguments}

\item{out}{what to return? see details}

\item{ranges}{if subject is not GenomicRanges, ranges to use when out is
positions}

\item{genome}{BSgenome object, only used if subect is
\code{\link[GenomicRanges]{GenomicRanges}}}
}
\value{
SummarizedExperiment with matches assay storing which peaks contain
which kmers
}
\description{
Find kmer matches in the DNA string-based subject
}
\details{
Can either return a SummarizedExperiment with just sparse matrix
with values set to 1 for a match (if return == 'matches'),  or a
GenomicRanges  object with all the positions of matches
}
\section{Methods (by class)}{
\itemize{
\item \code{matchKmers(k = character, subject = DNAStringSet)}: For DNAStringSet Objects

\item \code{matchKmers(k = character, subject = character)}: For character strings

\item \code{matchKmers(k = character, subject = DNAString)}: For DNA String objects

\item \code{matchKmers(k = character, subject = GenomicRanges)}: For GenomicRanges

\item \code{matchKmers(k = character, subject = RangedSummarizedExperiment)}: For RangedSummarizedExperiment (containing GRanges in
rowRanges)

\item \code{matchKmers(k = numeric, subject = ANY)}: Catch-all for other un-documented types

\item \code{matchKmers(k = DNAStringSet, subject = ANY)}: Catch-all for other un-documented types with 
DNAStringSet

\item \code{matchKmers(k = DNAString, subject = ANY)}: Catch-all for other un-documented types with DNAString

}}
\examples{

# Load very small example counts (already filtered)
data(mini_counts, package = "chromVAR")

# Get peak-kmer annotation matrix for 6mers
library(BSgenome.Hsapiens.UCSC.hg19)
kmer_ix <- matchKmers(6, mini_counts, 
                       genome = BSgenome.Hsapiens.UCSC.hg19)
}
\seealso{
\code{\link{getAnnotations}}, \code{\link{computeDeviations}}
}
