% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotVariability}
\alias{plotVariability}
\title{plotVariability}
\usage{
plotVariability(
  variability,
  xlab = "Sorted TFs",
  n = 3,
  labels = variability$name,
  use_plotly = interactive()
)
}
\arguments{
\item{variability}{output from \code{\link{computeVariability}}}

\item{xlab}{label for x-axis (default is 'Sorted TFs')}

\item{n}{number of toppoints to label?}

\item{labels}{names of sets. if not given, uses rownames of variability}

\item{use_plotly}{make plot interactive (using plotly)}
}
\value{
ggplot or plotly object, depending on whether use_plotly is TRUE
}
\description{
plot variability of motifs/etc
}
\examples{
# Load very small example results from computeDeviations
data(mini_dev, package = "chromVAR")
variability <- computeVariability(mini_dev)
var_plot <- plotVariability(variability, use_plotly = FALSE) 
}
\author{
Alicia Schep
}
