% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-geneTypeProfile.R
\name{geneTypeProfile}
\alias{geneTypeProfile}
\title{geneTypeProfile for the GRanges objects}
\usage{
geneTypeProfile(
    object,
    annotation,
    title = "Gene Type Profile",
    exlevel = NA,
    extranscript_support_level = NA
)
}
\arguments{
\item{object}{A GRanges object which should contains all the peaks that you
want to check}

\item{annotation}{A path way to the annotation file. The format of the
annotation file should be gff3 and downloaded from
https://www.gencodegenes.org/}

\item{title}{The main title for the output meta gene profile plot.}

\item{exlevel}{A parameter for the annotation filtering. exlevel represents
the level that you would like to exclude. NA means no level filtering
for the annotation file. The level from the annotations refers to
how reliable this annotation is. For more information about level
please check
https://www.gencodegenes.org/pages/data_format.html.}

\item{extranscript_support_level}{A parameter for the annotation filtering.
extranscript_support_level represents the transcript_support_level
that you would like to exclude (e.g. 4 and 5). NA means no
transcript_support_level filtering for the annotation file.
Transcripts are scored according to how well mRNA and EST alignments
match over its full length. Here the number 6 means the
transcript_support_level NA. For more information about level please
check
https://www.gencodegenes.org/pages/data_format.html.}
}
\value{
A list object, the list 1 contains the information of the
        assignment of the peaks and the gene type of their located genes.
        The list 2 includes the plot of geneTypeProfile
}
\description{
An function to check the gene type belonging for the peaks.
}
\details{
\itemize{
    Here is an explanation of output meta data in the \code{list 1}:
    \item \code{center}: The center position of each peaks. This center
    position is used for calculating the position of peaks within the
    genomic regions.
    \item \code{geneType}: The gene type of the gene that input peak belongs
    to.
    \item \code{Gene_ID}: The gene ID of the gene that input peak
    belongs to.
}
}
\examples{
## Load the test data and get the path to the test gff3 file
testpath <- system.file("extdata", package = "cliProfiler")
test <- readRDS(file.path(testpath, "test.rds"))
test_gff3 <- file.path(testpath, "annotation_test.gff3")

output <- geneTypeProfile(test, test_gff3)
}
\author{
You Zhou, Kathi Zarnack
}
