% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotReduceDim.R
\name{plotReducedDims}
\alias{plotReducedDims}
\alias{plotReducedDims,ClusterExperiment-method}
\title{Plot 2-dimensionsal representation with clusters}
\usage{
\S4method{plotReducedDims}{ClusterExperiment}(
  object,
  whichCluster = "primary",
  reducedDim = "PCA",
  whichDims = c(1, 2),
  plotUnassigned = TRUE,
  legend = TRUE,
  legendTitle = "",
  nColLegend = 6,
  clusterLegend = NULL,
  unassignedColor = NULL,
  missingColor = NULL,
  pch = 19,
  xlab = NULL,
  ylab = NULL,
  ...
)
}
\arguments{
\item{object}{a ClusterExperiment object}

\item{whichCluster}{argument that can be a single numeric or character value
indicating the \emph{single} clustering to be used. Giving values that result in more than one clustering will result in an error. See details of \code{\link{getClusterIndex}}.}

\item{reducedDim}{What dimensionality reduction method to use. Should match
either a value in \code{reducedDimNames(object)} or one of the built-in
functions of \code{\link{listBuiltInReducedDims}()}}

\item{whichDims}{vector of length 2 giving the indices of which dimensions to
show. The first value goes on the x-axis and the second on the y-axis.}

\item{plotUnassigned}{logical as to whether unassigned (either -1 or -2
cluster values) should be plotted.}

\item{legend}{either logical, indicating whether to plot legend, or character
giving the location of the legend (passed to \code{\link{legend}})}

\item{legendTitle}{character value giving title for the legend. If NULL, uses
the clusterLabels value for clustering.}

\item{nColLegend}{The number of columns in legend. If missing, picks number 
of columns internally.}

\item{clusterLegend}{matrix with three columns and colnames
'clusterIds','name', and 'color' that give the color and name of the
clusters in whichCluster. If NULL, pulls the information from
\code{object}.}

\item{unassignedColor}{If not NULL, should be character value giving the
color for unassigned (-1) samples (overrides \code{clusterLegend}) default.}

\item{missingColor}{If not NULL, should be character value giving the color
for missing (-2) samples (overrides \code{clusterLegend}) default.}

\item{pch}{the point type, passed to \code{plot.default}}

\item{xlab}{Label for x axis}

\item{ylab}{Label for y axis}

\item{...}{arguments passed to \code{\link{plot.default}}}
}
\value{
A plot is created. Nothing is returned.
}
\description{
Plot a 2-dimensional representation of the data, color-code by a
  clustering.
}
\details{
If \code{plotUnassigned=TRUE}, and the color for -1 or -2 is set to
  "white", will be coerced to "lightgrey" regardless of user input to
  \code{missingColor} and \code{unassignedColor}. If \code{plotUnassigned=FALSE},
  the samples with -1/-2 will not be plotted, nor will the category show up in the
  legend.

If the requested \code{reducedDim} method has not been created yet,
  the function will call \code{\link{makeReducedDims}} on the FIRST assay of
  \code{x}. The results of this method will be saved as part of the object
  and returned INVISIBLY (meaning if you don't save the output of the
  plotting command, the results will vanish). To pick another assay, you
  should call `makeReducedDims` directly and specify the assay.
}
\examples{
#clustering using pam: try using different dimensions of pca and different k
data(simData)

cl <- clusterMany(simData, nReducedDims=c(5, 10, 50), reducedDim="PCA",
clusterFunction="pam", ks=2:4, findBestK=c(TRUE,FALSE),
removeSil=c(TRUE,FALSE), makeMissingDiss=TRUE)

plotReducedDims(cl,legend="bottomright")
}
\seealso{
\code{\link{plot.default}}, \code{\link{makeReducedDims}}, \code{\link{listBuiltInReducedDims}()}
}
