% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_similarity.R
\name{get_similarity}
\alias{get_similarity}
\title{Compute similarity of matrices}
\usage{
get_similarity(
  expr_mat,
  ref_mat,
  cluster_ids,
  compute_method,
  pseudobulk_method = "mean",
  per_cell = FALSE,
  rm0 = FALSE,
  if_log = TRUE,
  low_threshold = 0,
  ...
)
}
\arguments{
\item{expr_mat}{single-cell expression matrix}

\item{ref_mat}{reference expression matrix}

\item{cluster_ids}{vector of cluster ids for each cell}

\item{compute_method}{method(s) for computing similarity scores}

\item{pseudobulk_method}{method used for summarizing clusters, options are mean (default), median, truncate (10\% truncated mean), or trimean, max, min}

\item{per_cell}{run per cell?}

\item{rm0}{consider 0 as missing data, recommended for per_cell}

\item{if_log}{input data is natural log,
averaging will be done on unlogged data}

\item{low_threshold}{option to remove clusters with too few cells}

\item{...}{additional parameters not used yet}
}
\value{
matrix of numeric values, clusters from expr_mat as row names,
cell types from ref_mat as column names
}
\description{
Compute similarity of matrices
}
