% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{process_ids}
\alias{process_ids}
\title{Return a subset of requested GCTX row/colum ids
out of the universe of all ids}
\usage{
process_ids(ids, all_ids, type = "rid")
}
\arguments{
\item{ids}{vector of requested ids. If \code{NULL}, no
subsetting is performed}

\item{all_ids}{vector of universe of ids}

\item{type}{flag indicating the type of ids being processed}
}
\value{
a list with the following elements
 \code{ids}: a character vector of the processed ids
 \code{idx}: an integer list of their corresponding indices in \code{all_ids}
}
\description{
Return a subset of requested GCTX row/colum ids
out of the universe of all ids
}
\details{
This is a low-level helper function
  which most users will not need to access directly
}
\examples{
gct_file <- system.file("extdata", "modzs_n25x50.gctx", package="cmapR")
ids <- read_gctx_ids(gct_file)
processed_ids <- cmapR:::process_ids(ids[1:10], ids)
str(processed_ids)

}
\seealso{
Other GCTX parsing functions: 
\code{\link{GCT}},
\code{\link{append.dim}()},
\code{\link{fix.datatypes}()},
\code{\link{parse.gctx}()},
\code{\link{read.gctx.ids}()},
\code{\link{read.gctx.meta}()},
\code{\link{write.gctx.meta}()},
\code{\link{write.gctx}()},
\code{\link{write.gct}()}
}
\concept{GCTX parsing functions}
\keyword{internal}
