% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codonUsage-expressivity.R
\docType{methods}
\name{codonUsage-expressivity}
\alias{codonUsage-expressivity}
\alias{MELP}
\alias{MELP,codonTable-method}
\alias{E}
\alias{E,codonTable-method}
\alias{CAI}
\alias{CAI,codonTable-method}
\alias{Fop}
\alias{Fop,codonTable-method}
\alias{GCB}
\alias{GCB,codonTable-method}
\title{Calculate CU expressivity measures.}
\usage{
MELP(cTobject, subsets = list(), ribosomal = FALSE,
  id_or_name2 = "1", alt.init = TRUE, stop.rm = FALSE,
  filtering = "none", len.threshold = 80)

\S4method{MELP}{codonTable}(cTobject, subsets = list(),
  ribosomal = FALSE, id_or_name2 = "1", alt.init = TRUE,
  stop.rm = FALSE, filtering = "none", len.threshold = 80)

E(cTobject, subsets = list(), ribosomal = FALSE, id_or_name2 = "1",
  alt.init = TRUE, stop.rm = FALSE, filtering = "none",
  len.threshold = 80)

\S4method{E}{codonTable}(cTobject, subsets = list(), ribosomal = FALSE,
  id_or_name2 = "1", alt.init = TRUE, stop.rm = FALSE,
  filtering = "none", len.threshold = 80)

CAI(cTobject, subsets = list(), ribosomal = FALSE, id_or_name2 = "1",
  alt.init = TRUE, stop.rm = FALSE, filtering = "none",
  len.threshold = 80)

\S4method{CAI}{codonTable}(cTobject, subsets = list(),
  ribosomal = FALSE, id_or_name2 = "1", alt.init = TRUE,
  stop.rm = FALSE, filtering = "none", len.threshold = 80)

Fop(cTobject, subsets = list(), ribosomal = FALSE, id_or_name2 = "1",
  alt.init = TRUE, stop.rm = FALSE, filtering = "none",
  len.threshold = 80)

\S4method{Fop}{codonTable}(cTobject, subsets = list(),
  ribosomal = FALSE, id_or_name2 = "1", alt.init = TRUE,
  stop.rm = FALSE, filtering = "none", len.threshold = 80)

GCB(cTobject, seed = logical(), ribosomal = FALSE, perc = 0.05,
  id_or_name2 = "1", alt.init = TRUE, stop.rm = FALSE,
  filtering = "none", len.threshold = 80)

\S4method{GCB}{codonTable}(cTobject, seed = logical(),
  ribosomal = FALSE, perc = 0.05, id_or_name2 = "1",
  alt.init = TRUE, stop.rm = FALSE, filtering = "none",
  len.threshold = 80)
}
\arguments{
\item{cTobject}{A \code{codonTable} object.}

\item{subsets}{A (named) list of logical vectors, the length of each equal
to \code{getlen(cTobject)}, i.e. the number of sequences in the set, or
character vectors (of any length) containing KEGG/eggNOG annotations,
or codonTable objects (of any length). 
Not used  for \code{ENC}, \code{SCUO} and \code{GCB} calculations.}

\item{ribosomal}{Logical, if \code{TRUE}, CU statistic is also calculated
against the average CU of the ribosomal genes in the sequence set.
Not used  for \code{ENC} and \code{SCUO} calculations.
For GCB calculations, if \code{TRUE}, ribosomal genes are used 
as a seed, and if \code{FALSE}  (default), \code{seed} 
has to be specified.}

\item{id_or_name2}{
    A single string that uniquely identifies the genetic code to extract.
    Should be one of the values in the \code{id} or \code{name2} columns
    of \code{GENETIC_CODE_TABLE}.
  }

\item{alt.init}{logical, whether to use alternative initiation codons.
Default is \code{TRUE}.}

\item{stop.rm}{Logical, whether to remove stop codons. Default is
\code{FALSE}.}

\item{filtering}{Character vector, one of \code{c("none", "soft", "hard")}.
Specifies whether sequences shorther than some threshold value of
length (in codons), \code{len.threshold}, should be excluded from
calculations. If \code{"none"} (default), length of sequences is not
checked, if \code{"soft"}, a warrning is printed if there are shorter
sequences, and if \code{"hard"}, these sequences are excluded from
calculation.}

\item{len.threshold}{Optional numeric, specifying sequence length,
in codons, used for filtering.}

\item{seed}{A logical vector, of the length equal to
\code{getlen(cTobject)}, or a character vector (of any length)
containing KEGG/eggNOG annotations, or a codonTable object
(of any length). Used only in GCB calculation. 
Indicates a set of genes, or their CU, to be used
as a target in the first iteration of the algorithm.}

\item{perc}{percent of top ranking genes to be used as a target set
for the next iteration of the algorithm that calculates GCB. 
Default is 0.05.}
}
\value{
A matrix (for GCB a numeric vector) with CU expressivity values 
   for every specified subset (\code{subsets}, \code{self}, 
   \code{ribosomal}) in columns.
}
\description{
Calculate values of the CU expressivity measure 
for every sequence in the given \code{codonTable} object.
The following methods are implemented:  
 \code{MELP}, CU expressivity measure based on
 Measure Independent of Length and Composition 
 \href{https://bit.ly/2GkT7qe}{Supek & Vlahovicek (2005)},
 \code{E}, gene expression measure (E) 
 \href{https://bit.ly/2pGLno5}{Karlin and Mrazek (2000)}, 
 \code{CAI}, Codon Adaptation Index (CAI) 
 \href{https://bit.ly/2HZuk8n}{Sharp and Li (1987)}, 
 \code{Fop}, frequency of optimal codons (Fop) 
 \href{https://www.ncbi.nlm.nih.gov/pubmed/6175758}{Ikemura (1981)}, 
 \code{GCB}, gene codon bias (GCB) 
 \href{http://www.ncbi.nlm.nih.gov/pubmed/14708578}{Merkl (2003)}.
}
\examples{
# load example DNA sequences
exampledir <- system.file("extdata", package = "coRdon")
cT <- codonTable(readSet(exampledir))

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
# In the examples below, MELP values are calculated for all sequences; 
# any other CU expressivity measure can be caluclated in the same way,
# the only exception being GCB which takes `seed` instead of `subset` 
# parameter. (The exemples for GCB calculation are further below).
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

# calculate MELP with respect to the CU
# of ribosomal genes among the example DNA sequences
melp <- MELP(cT, ribosomal = TRUE)
head(melp)

# calculate MELP distance with respect to the average CU
# of the first 20 example DNA sequences
# (i.e. the first half of the example DNA set)
melp <- MELP(cT, subsets = list(half = c(rep(TRUE, 20), rep(FALSE, 20))))

# alternatively, you can specify codonTable as a subset
halfcT <- codonTable(codonCounts(cT)[1:20,])
melp2 <- MELP(cT, subsets = list(half = halfcT))
all.equal(melp, melp2) # TRUE

# filtering
MELP(cT, ribosomal = TRUE,
     filtering = "hard", len.threshold = 80) # MELP for 9 sequences
                                             # (note that, accidentally,
                                             # all are ribosomal)
sum(getlen(cT) > 80) # 9 sequences are longer than 80 codons
melp1 <- MELP(cT, ribosomal = TRUE, filtering = "none") # no filtering
melp2 <- MELP(cT, ribosomal = TRUE, filtering = "soft") # warning
all.equal(melp1, melp2) # TRUE

# options for genetic code
melp <- MELP(cT, ribosomal = TRUE,
             stop.rm = TRUE) # don't use stop codons in calculation
melp <- MELP(cT, ribosomal = TRUE,
             alt.init = FALSE) # don't use alternative start codons
melp <- MELP(cT, ribosomal = TRUE,
             id_or_name2 = "2") # use different genetic code, for help
                                # see `?Biostrings::GENETIC_CODE`
                                
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
# GCB calculationd
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

# calculate GCB with CU of ribosomal genes among the example DNA sequences
# used as a target (seed) in the first iteration of the algorithm
gcb <- GCB(cT, ribosomal = TRUE)
head(gcb)

# calculate GCB distance with the first 20 example DNA sequences
# (i.e. the first half of the example DNA set) as a seed
gcb <- GCB(cT, seed = c(rep(TRUE, 20), rep(FALSE, 20)))

# alternatively, you can specify codonTable as a seed
halfcT <- codonTable(codonCounts(cT)[1:20,])
gcb2 <- GCB(cT, seed = halfcT)
all.equal(gcb, gcb2) # TRUE

# options for genetic code
gcb <- GCB(cT, ribosomal = TRUE,
           stop.rm = TRUE) # don't use stop codons in calculation
gcb <- GCB(cT, ribosomal = TRUE,
           alt.init = FALSE) # don't use alternative start codons
gcb <- GCB(cT, ribosomal = TRUE,
           id_or_name2 = "2") # use different genetic code, for help
                              # see `?Biostrings::GENETIC_CODE`
                              
}
