% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estOff.R
\name{estOff}
\alias{estOff}
\title{Estimate the row/column parameters of the independence model}
\usage{
estOff(
  data,
  distribution,
  rowOff,
  colOff,
  meanVarTrend,
  col,
  newtonRaphson,
  libSizes,
  ...
)
}
\arguments{
\item{data}{a list of data matrices with the same number of samples n
in the rows. Also phyloseq objects are acceptable}

\item{distribution}{a character string describing which distributional
assumption should be used.}

\item{rowOff, colOff}{current row and column offset estimates}

\item{meanVarTrend}{The estimated mean-variance trend}

\item{col}{A logical, should column offsets be estimated}

\item{newtonRaphson}{A boolean, should Newton-Raphson be used to solve the
estimating equations}

\item{libSizes}{The library sizes, used to evaluate the mean-variance trend}

\item{...}{passed onto nleqslv}
}
\value{
The estimated marginal parameters
}
\description{
Estimate the row/column parameters of the independence model
}
