% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_groups.R
\name{compare_groups}
\alias{compare_groups}
\title{hotspot comparison by group}
\usage{
compare_groups(data, regions, pvalue, threshold, name1, name2, include_genes)
}
\arguments{
\item{data}{a dataframe containing the chromosome, base pair
position, and optionally gene name of each mutation. Dataframe must contain
columns with the following names:
"Chromosome" <-- Chromosome number where the mutation is located
"Position" <-- Genomic position number where the mutation is located
"Sample" <-- Unique ID for each sample in dataset
"Gene" <-- Name of the gene which mutation is located in (optional)
"Group" <-- Group classification ID (group.spot only)}

\item{regions}{a dataframe containing the chromosome, start and
end base pair position of each region of interest}

\item{pvalue}{a threshold p-value for Kolmogorov-Smirnov test}

\item{threshold}{the cutoff empirical distribution for
Kolmogorov-Smirnov test}

\item{name1}{a string containing the name of one group for the
comparison}

\item{name2}{a string containing the name of the second group for
the comparison}

\item{include_genes}{true or false whether gene names are included
in regions dataframe}
}
\value{
a list containing the following:
\enumerate{
\item A dataframe with the hotspot, group, and mutation count from input
sample name
\item A plotly object violin plot comparing the mutation frequency per sample in groups as
given by "name1" and "name2" variables
\item An array of ECDF plots comparing the mutation frequency per sample in
groups as given by "name1" and "name2" variables
}
}
\description{
This function compares the mutation frequency of a panel of
genomic regions between two sub-groups.
}
\details{
This function creates a list of mutation frequency per unique
sample for each genomic regions separated based on specified
sub-groups. The regions with significant differences in mutation
distribution are calculated using a Kolmogorov-Smirnov test. The
difference in mutation frequency is output in a violin plot.
}
\examples{

data("compSPOT_example_mutations")
data("compSPOT_example_regions")
compare_groups(data = compSPOT_example_mutations,
regions = compSPOT_example_regions, pvalue = 0.05, threshold = 0.4,
name1 = "High-Risk", name2 = "Low-Risk", include_genes = TRUE)

}
