% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/imbalance_score.R
\name{imbalance_score}
\alias{imbalance_score}
\alias{imbalance_score,matrix-method}
\alias{imbalance_score,SingleCellExperiment-method}
\title{Imbalance Score}
\usage{
imbalance_score(Object, ...)

\S4method{imbalance_score}{matrix}(Object, conditions, k = 10, smooth = 10)

\S4method{imbalance_score}{SingleCellExperiment}(Object, dimred = 1, conditions, k = 10, smooth = 10)
}
\arguments{
\item{Object}{A \code{\link{SingleCellExperiment}} object or a matrix
representing the reduced dimension matrix of the cells.}

\item{...}{parameters including:}

\item{conditions}{Either the vector of conditions, or a character indicating which
column of the metadata contains this vector}

\item{k}{The number of neighbors to consider when computing the score.
Default to 10.}

\item{smooth}{The smoothing parameter. Default to k. Lower values mean that
we smooth more.}

\item{dimred}{A string or integer scalar indicating the reduced dimension
result in \code{reducedDims(sce)} to plot. Default to 1.}
}
\value{
Either a list with the \code{scaled_scores} and the \code{scores} for
 each cell, if input is a matrix, or the \code{\link{SingleCellExperiment}}
 object, wit this list in the \code{\link{colData}}.
}
\description{
Compute a imbalance score to show whether nearby cells have the
same condition of not
}
\examples{
data("toy_dataset")
scores <- imbalance_score(as.matrix(toy_dataset$sd[,1:2]),
  toy_dataset$sd$conditions, k = 4)
cols <- as.numeric(cut(scores$scaled_scores, 8))
plot(as.matrix(toy_dataset$sd[, 1:2]), xlab = "Dim1", ylab = "Dim2",
 pch = 16, col = RColorBrewer::brewer.pal(8, "Blues")[cols])
}
