% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/topologyTest.R
\name{topologyTest}
\alias{topologyTest}
\alias{topologyTest,SlingshotDataSet-method}
\alias{topologyTest,SingleCellExperiment-method}
\alias{topologyTest,PseudotimeOrdering-method}
\title{Differential Topology Test}
\usage{
topologyTest(sds, ...)

\S4method{topologyTest}{SlingshotDataSet}(
  sds,
  conditions,
  rep = 100,
  threshs = 0.01,
  methods = ifelse(dplyr::n_distinct(conditions) == 2, "KS_mean", "Classifier"),
  parallel = FALSE,
  BPPARAM = BiocParallel::bpparam(),
  args_mmd = list(),
  args_classifier = list(),
  args_wass = list(),
  nmax = nrow(slingshot::slingPseudotime(sds)),
  distinct_samples = NULL
)

\S4method{topologyTest}{SingleCellExperiment}(
  sds,
  conditions,
  rep = 100,
  threshs = 0.01,
  methods = ifelse(dplyr::n_distinct(conditions) == 2, "KS_mean", "Classifier"),
  parallel = FALSE,
  BPPARAM = BiocParallel::bpparam(),
  args_mmd = list(),
  args_classifier = list(),
  args_wass = list(),
  nmax = ncol(sds),
  distinct_samples = NULL
)

\S4method{topologyTest}{PseudotimeOrdering}(
  sds,
  conditions,
  rep = 100,
  threshs = 0.01,
  methods = ifelse(dplyr::n_distinct(conditions) == 2, "KS_mean", "Classifier"),
  parallel = FALSE,
  BPPARAM = BiocParallel::bpparam(),
  args_mmd = list(),
  args_classifier = list(),
  args_wass = list(),
  nmax = nrow(slingshot::slingPseudotime(sds)),
  distinct_samples = NULL
)
}
\arguments{
\item{sds}{A slingshot object already run on the full dataset. Can be either a
\code{\link{SlingshotDataSet}} or a \code{\link{SingleCellExperiment}} object.}

\item{...}{parameters including:}

\item{conditions}{Either the vector of conditions, or a character indicating which
column of the metadata contains this vector.}

\item{rep}{How many permutations to run. Default to 50.}

\item{threshs}{the threshold(s) for the KS test or classifier test. Default to .01
See \code{\link{ks_test}} and \code{\link{classifier_test}}.}

\item{methods}{The method(s) to use to test. Must be among 'KS_mean',
'Classifier', "KS_all', "mmd' and 'wasserstein_permutation'. See details.}

\item{parallel}{Logical, defaults to FALSE. Set to TRUE if you want to
parallellize the fitting.}

\item{BPPARAM}{object of class \code{bpparamClass} that specifies the
back-end to be used for computations. See
\code{bpparam} in \code{BiocParallel} package for details.}

\item{args_mmd}{arguments passed to the mmd test. See \code{\link{mmd_test}}.}

\item{args_classifier}{arguments passed to the classifier test. See \code{\link{classifier_test}}.}

\item{args_wass}{arguments passed to the wasserstein permutation test. See
\code{\link{wasserstein_permut}}.}

\item{nmax}{How many samples to use to compute the mmd test. See details.}

\item{distinct_samples}{The samples to which each cell belong to. Only use
with method `distinct`. See `\code{\link{distinct_test}}` for help.}
}
\value{
A list containing the following components:
\itemize{
  \item *method* The method used to test
  \item *thresh* The threshold (if relevant)
  \item *statistic* the value of the test statistic.
  \item *p.value* the p-value of the test.
}
}
\description{
Test whether or not slingshot should be fitted independently
for different conditions or not.
}
\details{
If there is only two conditions, default to `KS_mean`. Otherwise,
uses a classifier.

More than one method can be specified at once, which avoids running slingshot on
the permutations more than once (as it is the slowest part).

For the `mmd_test`, if `null=unbiased`, it is recommand to set `nmax=2000` or
something of that order of magnitude to avoid overflowing the memory.
}
\examples{
data('slingshotExample', package = "slingshot")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
condition <- factor(rep(c('A','B'), length.out = nrow(rd)))
condition[110:139] <- 'A'
sds <- slingshot::getLineages(rd, cl)
topologyTest(sds, condition, rep = 10)
}
