% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setOrientation.R
\name{setOrientation}
\alias{setOrientation}
\title{Set orientation for independent components}
\usage{
setOrientation(cica, verbose = FALSE)
}
\arguments{
\item{cica}{list compliant to `consICA()` result. Must contain GO, 
see `getGO()`}

\item{verbose}{logic TRUE or FALSE. Use TRUE for print process steps. 
Default is FALSE}
}
\value{
cica object after rotation, with rotated `S`, `M` and 
added `compsign` which is vector defined rotation: 
`S_rot = S * compsign, M_rot = M * compsign, GO_rot = GO * compsign`
}
\description{
Set orientation for independent components as positive in most 
enriched direction. Use first element of `GOs` for direction establishment.
}
\note{
Implemented inside `getGO()` in version >= 1.1.1.
}
\examples{
\dontrun{
data("samples_data")
# Get deconvolution of X matrix
#cica <-  consICA(samples_data, ncomp=10, ntry=1, show.every=0)
cica <- consICA(samples_data, ncomp=2, ntry=1, show.every=0) # timesaving 
example
GOs <- getGO(cica, db = "BP")
# Get already rotated S matrix and Gene Ontologies
cica <- getGO(cica, db = "BP")

# Get Gene Ontologies without rotation (actually, you don't need to do this)
# This may used for GO generated with version < 1.1.1. Add GO to cica list.
cica <- getGO(cica, db = "BP", rotate = FALSE)
# Rotate components
cica <- setOrientation(cica, verbose = T)
# Which components was rotated
which(cica$compsign == -1)
}
}
\author{
Petr V. Nazarov
}
