% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_wrappers.R
\name{diag_plots}
\alias{diag_plots}
\title{QC/diagnostic plotting}
\usage{
diag_plots(se_in = NULL, merged_in = NULL, write = FALSE,
  plot_dir = NULL, legend = TRUE, label = TRUE, name = NULL,
  mapped_reads = FALSE, rle = FALSE, pca = FALSE,
  residuals = FALSE, hclust = FALSE, density = FALSE,
  boxplot = FALSE, ma = FALSE, volcano = FALSE, p_dist = FALSE)
}
\arguments{
\item{se_in}{A "SeqExpressionSet" object or "RangedSummarizedExperiment"
generated using "buildSummarized()". If the input is a "SeqExpressionSet",
ensure that it included groups to be analysed. E.g. accessible as
"se_in$group. Groupings are used to automate colouring of samples in
unsupervised analyses. Default = NULL}

\item{merged_in}{A data.frame that contains the merged results which are
included in the outputs from multi_de_pairs(). These contain the ouputs from
the pair-wise comparisons which allows plotting of MA, Volcano and p-value
distributions. Where the outputs of multi_de_pairs() are to be used as inputs
 into diag_plots(), use multi_de_pairs()$merged as inputs. See example below.
  Default = NULL}

\item{write}{Write the results to a pdf file? Options: TRUE, FALSE. This is
to be used together with "plot_dir" and "write" parameters (below). Will
report an error and halt if is TRUE and "plot_dir" and "write" are NULL.
Default = FALSE}

\item{plot_dir}{If "write" is TRUE, where to write the files to? The
directory must already exist. E.g. "/path/to/my/pretty/plots/". Default =
NULL}

\item{legend}{Include legend in plots? Legend is based on group data in
se_in. Options: TRUE, FALSE. Default = FALSE}

\item{label}{Include point labels in plots? Points are based on ID column
from merged_in. Options: TRUE, FALSE. Default = FALSE}

\item{name}{If "write" is TRUE, what to name the plot? The file name will
always be preceded with "QC_" and end in ".pdf". E.g.
name="very_pretty_plots" will produce a file named "QC_very_pretty_plots.pdf"
 in "/path/to/my/pretty/plots/". Default = NULL}

\item{mapped_reads}{Plot mapped reads per sample as a barchart. Requires
se_in to be a "SeqExpressionSet" and utilise "group" meta-data for colouring.
 Options: TRUE, FALSE. Default = FALSE}

\item{rle}{Plot Relative Log Expressio (RLE) of samples for assessment of
sample quality. See ?plotRLE for further details. Requires se_in to be a
"SeqExpressionSet"and utilise "group" meta-data for colouring. Options: TRUE,
FALSE. Default = FALSE}

\item{pca}{Perform unsupervised Principle Component Analysis (PCA) and plot
results. By default performs Singular Value Decomposition. Requires se_in to
be a "SeqExpressionSet" and utilise "group" meta-data for colouring. Options:
 TRUE, FALSE. Default = FALSE}

\item{residuals}{If RUV-seq has been applied to dataset, plot the residuals
identified in the model. Only works for one set of residuals. Data is also
accessible using pData(se_in)$W_1. Requires se_in to be a "SeqExpressionSet"
and utilise "group" meta-data for colouring. Options: TRUE, FALSE. Default =
FALSE}

\item{hclust}{Performs unsupervised hierarchical clustering of samples.
Colours sample below plot according to group and numbered by inputs. Requires
 se_in to be a "SeqExpressionSet" and utilise "group" meta-data for
 colouring. Options: TRUE, FALSE. Default = FALSE}

\item{density}{Plot density distributions of log2(count-per-million). Will
automatically extract normalised counts over non-normalised counts is
available in "SeqExpressionSet". Requires se_in to be a "SeqExpressionSet"
and utilise "group" meta-data for colouring. Options: TRUE, FALSE. Default =
 FALSE}

\item{boxplot}{Boxplot of density distributions of log2(count-per-million).
Will automatically extract normalised counts over non-normalised counts is
available in "SeqExpressionSet". Requires se_in to be a "SeqExpressionSet"
and utilise "group" meta-data for colouring. Options: TRUE, FALSE. Default =
FALSE}

\item{ma}{Plot Mean versus. Log2 Fold-Change of comparison. Requires a
data.frame as input to "merged_in" with the following column names "ID",
"AvExpr", "Log2FC" and "Adj_PVal".The data frame should be sorted, as the top
 10 in the table are also  plotted. Options: TRUE,  FALSE. Default = FALSE}

\item{volcano}{Volcano plot of Log2 Fold-Change and significance of
comparison. Requires a data.frame as input to "merged_in" with the following
column names "ID", "AvExpr", "Log2FC" and "Adj_PVal". The data frame should
be sorted, as the top 10 in the table are also plotted. Options: TRUE,
FALSE. Default = FALSE}

\item{p_dist}{P-value distribution plot. Requires a data.frame as input to
"merged_in" with the following column names "ID", "AvExpr", "Log2FC" and
"Adj_PVal". The data frame should be sorted, as the top 10 in the table are
also plotted. Options: TRUE,  FALSE. Default = FALSE}
}
\value{
Returns pretty plots
}
\description{
Wrappers for a series of plots to be used as diagnostics in
RNA-seq analyses. Currently 10 plots are possible using this function: 1)
Mapped reads, 2) Relative Log Expression (RLE), 3) Principle Component
Analyis (PCA), 4) Residuals from a batch correction model, e.g. RUVseq, 5)
Hierarchical clustering, 6) Densitiy distributions, 7) Boxplots, 8) MA plots,
 9) Volcano Plots and 10) P-value distribution plots. Plots 1 to 6 utilise a
 "SeqExpressionSet" object for extracting information to plot. Plots 8-10
 utilised a simple list class, containing all the data.frames of each
 comparison performed. See descriptions of each in the parameter options
 below and for format specification. See vignette for more information and
 examples.
}
\examples{
## Load the example data set and attach
## The example below will display a PCA plot before normalisation
library(airway)
data(airway)
## Name the groups of the data.
colData(airway)$group <- colData(airway)$dex
## Identify the file locations
colData(airway)$file <- rownames(colData(airway))
## Filter low count data:
airway_filter <- buildSummarized(summarized = airway,
                                 filter = TRUE)
## for illustration, use random sample of 1000 transcripts
set.seed(1234)
airway_filter <- sample(airway_filter, 1000)
## The following is example code to perform a PCA plot
## see vignette for more details of displaying each plot
## diag_plots(se_in = airway_filter,
##            name = "airway example data",
##            pca = TRUE)
              
}
