% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_embedding.R
\name{biplot_corral}
\alias{biplot_corral}
\title{Generate biplot for corral object}
\usage{
biplot_corral(
  corral_obj,
  color_vec,
  text_vec,
  feat_name = "(genes)",
  nfeat = 20,
  xpc = 1,
  plot_title = "Biplot",
  text_size = 2,
  xjitter = 0.005,
  yjitter = 0.005,
  coords = c("svd", "PC", "SC")
)
}
\arguments{
\item{corral_obj}{list outputted by the \code{corral} function}

\item{color_vec}{vector; length should correspond to the number of rows in v of \code{corral_obj}, and each element of the vector classifies that cell (entry) in the embedding to that particular class, which will be colored the same. (e.g., cell type)}

\item{text_vec}{vector; length should correspond to the number of rows in u of \code{corral_obj}, and each element of the vector is the label for the respective feature that would show on the biplot.}

\item{feat_name}{char; the label will in the legend. Defaults to \code{(genes)}.}

\item{nfeat}{int; the number of features to include. The function will first order them by distance from origin in the selected dimensions, then select the top n to be displayed.}

\item{xpc}{int; which PC to put on the x-axis (defaults to 1)}

\item{plot_title}{char; title of plot (defaults to *Biplot*)}

\item{text_size}{numeric; size of the feature labels given in \code{text_vec} (defaults to 2; for \code{ggplot2})}

\item{xjitter}{numeric; the amount of jitter for the text labels in x direction (defaults to .005; for \code{ggplot2})}

\item{yjitter}{numeric; the amount of jitter for the text labels in y direction (defaults to .005; for \code{ggplot2})}

\item{coords}{char; indicator for sets of coordinates to use. \code{svd} plots the left and right singular vectors as outputted by SVD (\code{u} and \code{v}), which \code{PC} and \code{SC} use the principal and standard coordinates, respectively (defaults to \code{svd})}
}
\value{
ggplot2 object of the biplot
}
\description{
Generate biplot for corral object
}
\examples{
library(DuoClustering2018)
library(SingleCellExperiment)
zm4eq.sce <- sce_full_Zhengmix4eq()
zm4eq.countmat <- counts(zm4eq.sce)
zm4eq.corral_obj <- corral(zm4eq.countmat)
gene_names <- rowData(zm4eq.sce)$symbol
ctvec <- zm4eq.sce$phenoid

biplot_corral(corral_obj = zm4eq.corral_obj, color_vec = ctvec, text_vec = gene_names)
}
