% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{trim_matdist}
\alias{trim_matdist}
\title{Trim extreme values in a pre-processed matrix}
\usage{
trim_matdist(mat, pct_trim = 0.01)
}
\arguments{
\item{mat}{matrix; should be pre-processed/normalized to some sort of approximately normally distributed statistic (e.g., chi-squared transformation with `corral_preproc` or Z-score normalization)}

\item{pct_trim}{numeric; the percent of observations to smooth.  Defaults to `pct_trim` = .01, which corresponds to smoothing all observations to be between the .5 percentile and 99.5 percentile range of the input matrix}
}
\value{
smoothed matrix
}
\description{
Smooths the extreme values in a chi-square-transformed matrix to lessen the influence of "rare objects."
}
\details{
(Usually not called directly; can be included by using the `smooth` argument in the `corral`, `corralm`, and `corral_preproc` functions)
}
\examples{
count_mat <- matrix(rpois(10000, 300)*rbinom(10000,1,.1), ncol = 100)
smoothed_preproc_mat <- corral_preproc(count_mat, smooth = TRUE)
}
