#' Toy Input Transcription Data Set
#' 
#' This exemplary transcription data are the specific deregulated gene expression of the 786-O cell line from the NCI60 dataset.
#' 
#' @docType data
#'
#' @usage data(toy_RNA)
#'
#' @format An object of class \dQuote{\code{numeric}} containing the t-values of
#'   9300 genes, which are named with gene symboles matching the toy network.
#'
#' @source 
#'   \url{https://github.com/saezlab/COSMOS_MSB/blob/main/data/RNA_ttop_tumorvshealthy.csv}
#' 
#' @references {
#'   Dugourd, A., Kuppe, C. and Sciacovelli, M. et. al. (2021) \emph{Molecular 
#'   Systems Biology}. \bold{17}, e9730.
#' }
#' 
#' @examples
#' data(toy_RNA)
#' 
#' @keywords datasets
"toy_RNA"