% Generated by roxygen2 (4.0.1): do not edit by hand
\name{vegasMarginal}
\alias{vegasMarginal}
\title{Calculate the P-Value for a Set Using the VEGAS Method}
\usage{
vegasMarginal(pvals, ld_matrix, num_sims, correction = TRUE, seed = NULL,
  verbose = FALSE)
}
\arguments{
\item{pvals}{A vector of p-values corresponding to items in
the set.}

\item{ld_matrix}{A square, symmetric matrix of LD values, with
each row and column corresponding to each of the items in the
set. The diagonal entries should be 1, indicating the LD
between an item in the set and itself is 1.}

\item{num_sims}{An integer value for the number of simulations
to be performed.}

\item{correction}{A logical argument indicating whether a
value of one should be added to the numerator when calculating
the p-value based upon the simulated statistics. By default,
the correction is added. An argument of FALSE will not add one
to the numerator.}

\item{seed}{An integer argument indicating what the random
seed should be set to. This allows for replication of results.
The default is NULL, and a random seed will be set internally.}

\item{verbose}{A logical argument indicating whether periodic
output should be printed. Defaults to FALSE, indicating no
output will be printed.}
}
\value{
A \code{VEGASResult} object with the corresponding
VEGAS results.
}
\description{
Calculates the p-value representing the association of the
set with the phenotype of interest.
}
\details{
This is a helper function to calculate the p-value for a set
of SNPs that reside within a gene set collection. The
correlation among the SNPs is taken into account by the LD
matrix. The resulting p-value is calculated from a null
distribution that is simulated \code{num_sims} times based upon
the specified correlation structure.
}
\author{
Caitlin McHugh \email{mchughc@uw.edu}
}

