% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crisprShiny.R
\name{crisprShiny}
\alias{crisprShiny}
\title{Interactive visualization of GuideSets via Shiny applications}
\usage{
crisprShiny(guideSet, geneModel = NULL, useFilterPresets = TRUE)
}
\arguments{
\item{guideSet}{A GuideSet object.}

\item{geneModel}{A GRangesList object obtained using
\code{crisprDesign::TxDb2GRangesList}.}

\item{useFilterPresets}{Whether to use preset filter values on app launch.
See details.}
}
\value{
A Shiny app object.
}
\description{
Means to interactively visualize gRNAs within a \code{GuideSet}
object via a Shiny application. Contents of the Shiny app reflect
annotations contained within the \code{GuideSet} object, and provide
intuitive controls to examine, filter, and export \code{.csv} tables of gRNAs.
}
\details{
Preset filter values

Using sensible, preset filters can conveniently remove many poorer-quality
gRNAs from view upon app launch. This can be done by setting
\code{useFilterPresets=TRUE}, while passing \code{FALSE} will retain all gRNAs in
\code{guideSet}. Of course, filters can still be adjusted within the app to
either further refine or broaden the list of gRNAs to view. Setting
\code{useFilterPresets=TRUE} (default) will impose the following filter
criteria, as appropriate to the \code{guideSet}, upon app launch:
\itemize{
\item spacers with polyT are excluded
\item permissible spacer percent GC range set to [20, 80]
\item spacers missing values for any score method (\code{NA}) are excluded
\item (SpCas9 nuclease only) minimum permissible DeepHF and DeepSpCas9 scores set
to 0.5
\item spacers targeting repeat elements are excluded
\item spacers overlapping SNPs are excluded
\item (for GuideSets having gene annotation) spacers targeting the final 15\%
of the gene CDS (i.e., 3' end) are excluded
}

Filters will not be applied if the \code{guideSet} lacks the necessary annotation.
For example, a \code{guideSet} lacking SNP annotation will not be filtered on the
SNP criterium.
}
\examples{
    library(crisprShiny)
    data("guideSetExample_kras", package="crisprShiny")
    app <- crisprShiny(guideSetExample_kras)
    
    if (interactive()) {
        shiny::runApp(app)
    }
    
}
