% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytoHDBMW.R
\docType{data}
\name{cytoHDBMW}
\alias{cytoHDBMW}
\title{Example of processed dimensionally reduced flow cytometry
(marker median intensities) Bodenmiller_BCR_XL_flowSet()
expression dataset from HDCytoData Bioconductor data package.}
\format{
SummarizedExperiment assay object containing
126 cluster-marker median expression intenities (features)
of 8 subjects (samples).
}
\usage{
data(cytoHDBMW)
}
\description{
The raw data (fcs files) were pre-processed using
CATALYST, scuttle, scran Bioconductor packages and igraph
CRAN package.
The data processing package includes 4 steps and
they are as follows:
1. Creating a SingleCellExperiment Object: the flowSet
data object along with the metadata are converted into a
SingleCellExperiment object using the CATALYST R/Bioconductor package.
2. Clustering: We apply Louvain algorithm using the R package
igraph to cluster the expression values by the type markers
(surface markers).
3. Median: Medians are calculated within a cluster for every
signaling marker and subject.
4. Aggregating and converting the data: We convert the
aggregated data into a SummarizedExperiment.
The row meta-data indicates
"cluster" corresponding to the cluster id for each protein marker.
The colData represents the "sample_id", "condition", "patient_id",
"ids"
The remaining columns indicate median expression intensities
for each of the 126 (14 markers * 9 clusters) cluster combination
for each sample.
}
\details{
The HDCytoData package is an extensible resource containing
a set of publicly available high-dimensional flow cytometry
and mass cytometry (CyTOF) benchmark datasets hosted on
Bioconductor’s ExperimentHub platform.
}
\examples{
data(cytoHDBMW)
}
\references{
Weber, M L, Soneson, Charlotte (2019). 
“HDCytoData: Collection of high-dimensional cytometry 
benchmark datasets in Bioconductor object formats.” 
F1000Research, 8(v2), 1459.
}
\keyword{datasets}
