% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCombs.R
\name{getCombs}
\alias{getCombs}
\title{Identifies subgroupings of replicates for assessing within-group and between-group variation.}
\usage{
getCombs(
  reps_A,
  reps_B,
  batches = FALSE,
  between_combs = NULL,
  within_combs = NULL
)
}
\arguments{
\item{reps_A}{Number of replicates of group A.}

\item{reps_B}{Number of replicates of group B.}

\item{batches}{Logical suggesting if replicates of group A and B were performed in batches and are labelled accordingly. If TRUE, a heterogeneous/homogeneous subset may not have multiple samples from the same batch.}

\item{between_combs}{Dataframe with each column containing groupings of replicates of groups A and B, which will be used to assess between-group variation.}

\item{within_combs}{Data.frame with each column containing groupings of replicates of groups A or B, which will be used to assess within-group variation.}
}
\value{
List of two dataframes, containing groupings for within-group and between-group variation.
}
\description{
Regroup all the samples of A and B groups into homogoneous and
heterogeneous sub-groups. Each homogenous sub-group contains replicates of either
group A only or group B only. Each heterogeneous sub-group has a mix of samples from
both the groups A and B.
}
\examples{
#Get heterogeneous and homogeneous set combinations of samples when there are 2 samples of group A and 1 of group B.
getCombs(2, 1)
}
\references{
Choudhary, K., Lai, Y. H., Tran, E. J., & Aviran, S. (2019).
dStruct: identifying differentially reactive regions from RNA
structurome profiling data. \emph{Genome biology}, 20(1), 1-26.
}
\author{
Krishna Choudhary
}
