% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testDAU.R
\name{addScheme}
\alias{addScheme}
\title{Add a custom coloring or grouping scheme.}
\usage{
addScheme(
  color = vector("character"),
  symbol = vector("character"),
  group = NULL
)
}
\arguments{
\item{color}{A named vector of character. This vector specifies
different colors for visualizing the different amino acids or amino acid groups.}

\item{symbol}{A named vector of character. This vector specifies the 
different symbols for visualizing the different amino acids or amino acid groups.}

\item{group}{A list or NULL. If only coloring amino acids of similar property is
desired, set \code{group} to NULL; otherwise \code{group} should be a list with
same names as those of \code{color} and \code{symbol}.}
}
\value{
Add the custom coloring or grouping scheme to the environment 
\code{cacheEnv}.
}
\description{
Add a custom coloring or grouping scheme for ungrouped or grouped amino acids
as desired.
}
\examples{
## Add a grouping scheme based on the BLOSUM50 level 3 
color = c(LVIMC = "#33FF00", AGSTP = "#CCFF00",
         FYW = '#00FF66', EDNQKRH = "#FF0066")
symbol = c(LVIMC = "L", AGSTP = "A", FYW = "F", EDNQKRH = "E")
group = list(
   LVIMC = c("L", "V", "I", "M", "C"), 
   AGSTP = c("A", "G", "S", "T", "P"),
   FYW = c("F", "Y", "W"),
   EDNQKRH = c("E", "D", "N", "Q", "K", "R", "H"))
addScheme(color = color, symbol = symbol, group = group) 

}
