% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanPeptides.R
\name{cleanPeptides}
\alias{cleanPeptides}
\title{clean up peptides}
\usage{
cleanPeptides(dat, anchors)
}
\arguments{
\item{dat}{input data. The input dat contains two columns `symbol`, protein ID,
and `peptides`, peptide sequence.The anchoring amino acid must be in lower case.}

\item{anchors}{A vector of character, anchoring amino acid must be in lower case.}
}
\value{
A data.frame with columns: `symbol`, `peptides` and `anchor`
}
\description{
clean up the input peptide subsequences. The function removes 
peptides which do NOT contain any anchoring amino acid. Adds peptide for
each additional anchor in each peptide, and allows multiple anchoring amino acids.
}
\examples{
dat <- read.csv(system.file("extdata", "peptides2filter.csv", package="dagLogo"))
dat
dat.new <- cleanPeptides(dat, anchors = c("s", "t"))
}
\author{
Jianhong Ou, Julie Zhu
}
\keyword{misc}
