% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{seq.example}
\alias{seq.example}
\title{An object of \code{\link{dagPeptides-class}} representing acetylated lysine-containing peptides.}
\format{
An object of \code{\link{dagPeptides-class}} Class
  The format is: A list.
  
    *`data`: 'data.frame':    732 obs. of  7 variables
    *`peptides`: 'matrix':   amnio acid in each position
    *`upstreamOffset`: an integer, upstream offset position
    *`downstreamOffset`: an integer, downstream offset position
    *`type`: "character", type of identifiers
  
  The format of data is

    *`IDs`: a character vector, input identifiers
    *`anchorAA`: a character vector, anchor amino acid provided in inputs
    *`anchorPos`: a numeric vector, anchor position in the protein
    *`peptide`: a character vector, peptide sequences
    *`anchor`: a character vector, anchor amino acid in the protein
    *`upstream`: a character vector, upstream peptides
    *`downstream`: a character vector, downstream peptides
}
\usage{
seq.example
}
\description{
A dataset containing the acetylated lysine-containing peptides from \emph{Drosophila melanogaster}.
}
\details{
used as an example dataset
  
  seq obtained by:
  
    mart <- useMart("ensembl", "dmelanogaster_gene_ensembl")
    
    dat <- read.csv(system.file("extdata", "dagLogoTestData.csv", package="dagLogo"))
    
    seq <- fetchSequence(as.character(dat$entrez_geneid), 
    
                       anchorPos=as.character(dat$NCBI_site), 
                       
                       mart=mart, 
                       
                       upstreamOffset=7, 
                       
                       downstreamOffset=7)
}
\examples{
  data(seq.example)
  head(seq.example@peptides)
  seq.example@upstreamOffset
  seq.example@downstreamOffset
}
\keyword{datasets}
