% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miloUmap.R
\name{miloUmap}
\alias{miloUmap}
\title{Perform UMAP on the Adjacency Matrix of a Milo Object}
\usage{
miloUmap(
  milo,
  slot_name = "UMAP_knngraph",
  n_neighbors = 50L,
  metric = "euclidean",
  min_dist = 0.3,
  use_graph = TRUE,
  ...
)
}
\arguments{
\item{milo}{the milo object with knn graph that needed to conduct umap on.}

\item{slot_name}{character, with default 'UMAP_knngraph'.
\itemize{
\item The slot name in reduceDim where the result store
}}

\item{n_neighbors}{integer, with default 50L.
\itemize{
\item the size of local neighborhood (in terms of number of
neighboring sample points) used for manifold approximation.
\item Here, the goal is to create large enough neighborhoods to capture
the local manifold structure to allow for hypersampling.
}}

\item{metric}{character, with default 'euclidean'
\itemize{
\item the choice of metric used to measure distance to find nearest neighbors.
Default is 'euclidean'.
}}

\item{min_dist}{numeric, with default 0.3
\itemize{
\item the minimum distance between points in the low dimensional space
}}

\item{use_graph}{Logical, default TRUE.
\itemize{
\item Whether to run UMAP on the graph adjacency matrix (TRUE) as in Dandelion,
or directly on the latent space (FALSE) for faster performance.
}}

\item{...}{other parameters passed to uwot::umap}
}
\value{
milo object with umap reduction
}
\description{
This function uses \code{uwot::umap} to perform UMAP dimensionality
reduction on the adjacency matrix of the KNN graph in a Milo object.
}
\examples{
data(sce_vdj)
# downsample to just 1000 cells
sce_vdj <- sce_vdj[, 1:1000]
sce_vdj <- setupVdjPseudobulk(sce_vdj,
    already.productive = FALSE,
    allowed_chain_status = c("Single pair", "Extra pair")
)
# Build Milo Object
milo_object <- miloR::Milo(sce_vdj)
milo_object <- miloR::buildGraph(milo_object,
    k = 50, d = 20,
    reduced.dim = "X_scvi"
)
milo_object <- miloR::makeNhoods(milo_object,
    reduced_dims = "X_scvi", d = 20
)

# Construct UMAP on Milo Neighbor Graph
milo_object <- miloUmap(milo_object)

}
