% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{contains_rarefaction}
\alias{contains_rarefaction}
\title{Checks if Recipe contains a rarefaction step}
\usage{
contains_rarefaction(rec)
}
\arguments{
\item{rec}{A Recipe object. The step will be added to the sequence of
operations for this recipe.}
}
\value{
boolean
}
\description{
Checks if Recipe contains a rarefaction step
}
\examples{
data(GlobalPatterns, package = "phyloseq")
rec <-
  phyloseq::subset_samples(
    GlobalPatterns, SampleType \%in\% c("Soil", "Skin")
  ) |>
  recipe(var_info  = "SampleType", tax_info = "Genus") |>
  step_rarefaction()

contains_rarefaction(rec)
}
