% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_input.R
\name{generate_input}
\alias{generate_input}
\title{Generate a random input for graph diffusion}
\usage{
generate_input(graph, order, length_inputs, return_matrix = TRUE, seed = NULL)
}
\arguments{
\item{graph}{an \pkg{igraph} object, typically from
\code{\link{generate_input}}}

\item{order}{numeric or vector, order of the neighbourhoods that generate
the list}

\item{length_inputs}{numeric, number of nodes in the generated inputs}

\item{return_matrix}{logical, should inputs be returned as a matrix?}

\item{seed}{numeric, seed for random number generator}
}
\value{
A list whose elements are lists with three slots:
\code{pos} for the true signal generators, \code{neg} for the
nodes that did not generate signal and \code{input} for the
signal itself
}
\description{
Function \code{generate_input} generates a random list of
nodes from an \pkg{igraph} object.
It also specifies the true solution generating the
list. The graph object needs to have some attributes
(automatically added through \code{generate_graph})
}
\examples{
g <- generate_graph(
    fun_gen = igraph::barabasi.game,
    param_gen = list(n = 200, m = 3, directed = FALSE),
    seed = 1)
synth_input <- generate_input(
    g,
    order = 2,
    length_inputs = 3, return_matrix = TRUE)
str(synth_input)

}
