% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/general.R
\name{correlation}
\alias{correlation}
\title{Correlation test}
\usage{
correlation(x, y = NULL, method = c("pearson", "spearman", "kendall"),
  pairwise = FALSE)
}
\arguments{
\item{x}{Numeric vector or matrix}

\item{y}{Optional numeric vector or matrix}

\item{method}{Character string indicating the correlation method}

\item{pairwise}{Logical, wether columns of x and y should be compared in a pairwise manner. x and y must have the same number of columns}
}
\value{
Numeric value, vector or matrix of results
}
\description{
This function computes the correlation between x and y given both are numeric vectors, between the columns of x if it is a numeric matrix, or between the columns of x and y if both are numeric matrixes
}
\details{
This function computes correlation and associated p-values
}
\examples{
x <- seq(0, 10, length=50)
y <- x+rnorm(length(x), sd=2)
correlation(x, y)
}

