% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/general.R
\name{mutualInfo}
\alias{mutualInfo}
\title{Mutual information}
\usage{
mutualInfo(x, y = NULL, per = 0, pairwise = FALSE, bw = 100,
  cores = 1, verbose = TRUE)
}
\arguments{
\item{x}{Numeric vector or matrix}

\item{y}{Optional numeric vector or matrix}

\item{per}{Integer indicating the number of permutations to compute p-values}

\item{pairwise}{Logical, wether columns of x and y should be compared in a pairwise maner. x and y must have the same number of columns}

\item{bw}{Integer indicating the grid size for integrating the joint probability density}

\item{cores}{Integer indicating the number of cores to use (1 for Windows-based systems)}

\item{verbose}{Logical, whether progression bars should be shown}
}
\value{
Numeric value, vector or matrix of results
}
\description{
This function estimates the mutual information between x and y given both are numeric vectors, between the columns of x if it is a numeric matrix, or between the columns of x and y if both are numeric matrixes
}
\details{
This function estimates the mutual information between continuous variables using a fix bandwidth implementation
}
\examples{
x <- seq(0, pi, length=100)
y <- 5*sin(x)+rnorm(100)
cor.test(x, y)
mutualInfo(x, y, per=100)
}

