% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_densities.R
\name{plot_densities}
\alias{plot_densities}
\title{Plot sample-specific densities.}
\usage{
plot_densities(
  x,
  name_assays_expression = "logcounts",
  name_cluster = "cluster_id",
  name_sample = "sample_id",
  name_group = "group_id",
  cluster,
  gene,
  group_level = FALSE,
  adjust = 1,
  size = 0.75
)
}
\arguments{
\item{x}{a \code{\linkS4class{SummarizedExperiment}} or a \code{\linkS4class{SingleCellExperiment}} object.}

\item{name_assays_expression}{a character ("logcounts" by default), 
indicating the name of the assays(x) element which stores the expression data (i.e., assays(x)$name_assays_expression).
We strongly encourage using normalized data, such as counts per million (CPM) or log-CPM.}

\item{name_cluster}{a character ("cluster_id" by default), 
indicating the name of the colData(x) element which stores the cluster id of each cell (i.e., colData(x)$name_colData_cluster).}

\item{name_sample}{a character ("sample_id" by default), 
indicating the name of the colData(x) element which stores the sample id of each cell (i.e., colData(x)$name_colData_sample).}

\item{name_group}{a character ("group_id" by default), 
indicating the name of the colData(x) element which stores the group id of each cell (i.e., colData(x)$name_colData_group).}

\item{cluster}{a character, indicating the name of the cluster to plot.}

\item{gene}{a character, indicating the name of the gene to plot.}

\item{group_level}{a logical, indicating whether to plot group-level (if TRUE) or sample-level curves (if FALSE).}

\item{adjust}{a numeric, representing a multiplicate bandwidth adjustment, argument passed to \code{\link{stat_density}}.}

\item{size}{a numeric argument defining the width of lines, passed to \code{\link{stat_density}}.}
}
\value{
A \code{\link{ggplot}} object.
}
\description{
\code{plot_densities} returns a \code{\link{ggplot}} object
with the sample-specific density estimates, for a specified cluster and gene.
}
\examples{
data("Kang_subset", package = "distinct")
Kang_subset

plot_densities(x = Kang_subset,
               gene = "ISG15",
               cluster = "Dendritic cells",
               name_assays_expression = "logcounts",
               name_cluster = "cell",
               name_sample = "sample_id",
               name_group = "stim")

}
\seealso{
\code{\link{distinct_test}}, \code{\link{plot_cdfs}}
}
\author{
Simone Tiberi \email{simone.tiberi@uzh.ch}
}
