% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_fxns.R
\name{convert_genes}
\alias{convert_genes}
\title{Use biomaRt to convert genes}
\usage{
convert_genes(
  genes,
  from = c("ENSMUSG", "ENSG", "MGI", "HGNC"),
  to = c("MGI", "HGNC"),
  host = "https://www.ensembl.org"
)
}
\arguments{
\item{genes}{Vector of genes to convert.}

\item{from}{Format of gene input (ENSMUSG, ENSG, MGI, or HGNC)}

\item{to}{Format of gene output (MGI or HGNC)}

\item{host}{Host to connect to. Defaults to https://www.ensembl.org following the useMart default, but can be changed to archived hosts if useMart fails to connect.}
}
\value{
A data frame with input genes as column 1 and converted genes as column 2
}
\description{
This function reads in a vector of genes and converts the genes to specified symbol type
}
\keyword{internal}
