% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_fxns.R
\name{count_linkage}
\alias{count_linkage}
\title{Count occurrences of linkages across multiple domino results from a linkage summary}
\usage{
count_linkage(
  linkage_summary,
  cluster,
  group.by = NULL,
  linkage = "rec_lig",
  subject_names = NULL
)
}
\arguments{
\item{linkage_summary}{a \code{\link[=linkage_summary]{linkage_summary()}} object}

\item{cluster}{the name of the cell cluster being compared across multiple domino results}

\item{group.by}{the name of the column in \code{linkage_summary@subject_meta} by which to group subjects for counting. If NULL, only total counts of linkages for linkages in the cluster across all subjects is given.}

\item{linkage}{a stored linkage from the domino object. Can compare any of 'tfs', 'rec', 'incoming_lig', 'tfs_rec', or 'rec_lig'}

\item{subject_names}{a vector of subject_names from the linkage_summary to be compared. If NULL, all subject_names in the linkage summary are included in counting.}
}
\value{
A data frame with columns for the unique linkage features and the counts of how many times the linkage occured across the compared domino results. If group.by is used, counts of the linkages are also provided as columns named by the unique values of the group.by variable.
}
\description{
Count occurrences of linkages across multiple domino results from a linkage summary
}
\examples{
count_linkage(
  linkage_summary = mock_linkage_summary(), cluster = "C1", 
  group.by = "group", linkage = "rec")

}
