% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_diffs.R
\name{test_diffs}
\alias{test_diffs}
\title{test_diffs Statistics function to summarize expression
data of an object, using ratios between selected treatments.}
\usage{
test_diffs(se, groupings= NULL, treatment1=NULL, treatment2=NULL,
mode_mean=TRUE, LOG2=TRUE)
}
\arguments{
\item{se}{A SummarizedExperiment object.}

\item{groupings}{A grouping (annotation column); groupings="annotation.ZA".}

\item{treatment1}{Symbol, treatment 1.}

\item{treatment2}{Symbol, treatment 2.}

\item{mode_mean}{Boolean, Calculate RowMeans or RowMedians.}

\item{LOG2}{Boolean, Calculate LOG2.}
}
\value{
Returns an invisible list of summary statistics,
kruskal test and raw data of an object, using ratios
between selected treatments.
}
\description{
generateStats is a summary function used on various
expression data, using ratios between selected treatments.
}
\details{
This function completes summary statistics of the expression of
the supplied SummarizedExperiment object.
}
\examples{
data(hmel.se)
test_diffs(se, groupings='annotation.ZA',treatment1="Male",
treatment2="Female" )
}
\references{
The "doseR" package, 2018 (in press).
}
\author{
AJ Vaestermark, JR Walters.
}
