% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVoom.R
\docType{methods}
\name{plotVoom}
\alias{plotVoom}
\alias{plotVoom,dreamletProcessedData-method}
\alias{plotVoom,dreamletProcessedData,dreamletProcessedData-method}
\alias{plotVoom,EList-method}
\alias{plotVoom,list,list-method}
\title{Plot voom curves from each cell type}
\usage{
plotVoom(x, ncol = 3, alpha = 0.5, ...)

\S4method{plotVoom}{dreamletProcessedData}(x, ncol = 3, alpha = 0.5, assays = names(x))

\S4method{plotVoom}{EList}(x, ncol = 3, alpha = 0.5)
}
\arguments{
\item{x}{dreamletProcessedData}

\item{ncol}{number of columns in the plot}

\item{alpha}{transparency of points}

\item{...}{other arguments}

\item{assays}{which assays to plot}
}
\value{
Plot of mean-variance trend
}
\description{
Plot voom curves from each cell type
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# Show mean-variance trend from voom
plotVoom(res.proc)

# plot for first two cell types
plotVoom(res.proc[1:2])

}
