% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stackAssays.R
\name{stackAssays}
\alias{stackAssays}
\title{Stack assays from pseudobulk}
\usage{
stackAssays(pb, assays = assayNames(pb))
}
\arguments{
\item{pb}{pseudobulk \code{SingleCellExperiment} from \code{aggregateToPseudoBulk()}}

\item{assays}{array of assay names to include in analysis. Defaults to \code{assayNames(pb)}}
}
\value{
pseudobulk \code{SingleCellExperiment} cbind'ing expression values and rbind'ing colData.  The column \code{stackedAssay} in \code{colData()} stores the assay information of the stacked data.
}
\description{
Stack assays from pseudobulk to perform analysis across cell types
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# Stack assays for joint analysis
pb.stack <- stackAssays(pb)

# voom-style normalization
# assay (i.e. cell type) can now be included as a covariate
res.proc <- processAssays(pb.stack, ~ group_id + stackedAssay)

# variance partitioning analysis
vp <- fitVarPart(res.proc, ~ group_id + stackedAssay)

# Summarize variance fractions across cell types
plotVarPart(sortCols(vp))

# Interaction analysis allows group_id
# to have a different effect within each stacedAssay
vp2 <- fitVarPart(res.proc, ~ group_id * stackedAssay)

plotVarPart(sortCols(vp2))

# Interaction model using random effects
form <- ~ (1 | group_id) + (1 | stackedAssay) + (1 | group_id:stackedAssay)
#
}
